SaveScore = copy_table(BaseView)
SaveScore.definition = "save_score"


function SaveScore:init(options)
    BaseView.init(self)
    self.game_guid = options and options.game_guid or "klondike"
    self.score = options.score
    self.shortcuts.score:set_text(string.format(str.save_score_score, self.score))
end


function SaveScore:proceed()
    fw:change_view(StorySelector, { won_game = true })
end


function SaveScore:yes_button(obj)
    top_scores:add_score(self.game_guid, "player", self.shortcuts.name:get_text(), self.score, true)
    self:proceed()
end


function SaveScore:no_button(obj)
    top_scores:add_score(self.game_guid, "player", self.shortcuts.name:get_text(), self.score, false)
    self:proceed()
end
